\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{spex}[2004/10/26 v1.1 Dataspelets spexmanus]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[a4paper, twoside, titlepage, 11pt]{article}
\def\@grdriv@r{\ifx\pdftexversion\@undefined dvips\else pdftex\fi}
\RequirePackage[T1]{fontenc}
\RequirePackage[latin1]{inputenc}
\RequirePackage[swedish]{babel}
\RequirePackage[\@grdriv@r, includeheadfoot, left=3cm, right=3.5cm, top=1.5cm, bottom=2cm]{geometry}
\RequirePackage{fancyhdr}
\RequirePackage{palatino}
\RequirePackage[\@grdriv@r]{color}
\RequirePackage[\@grdriv@r]{graphicx}
\RequirePackage{lastpage}
\RequirePackage{extramarks}
\RequirePackage{ifthen}
%
\newenvironment{spex}{\document}{\enddocument}
\newcommand\akt[1]{\section*{#1}}
\newcommand\scen[1]{\subsection*{Scen #1}\@scen}
\newcommand\@scen[6]{%
	\begin{center}%
	\scenbeskrstorl
	\begin{tabular}{lp{6cm}}%
		\ifthenelse{\equal{#1}{}}{{\sf Namn}& Namn ej klart}{{\sf Namn}& #1}
		\ifthenelse{\equal{#2}{}}{}{\\{\sf Beskrivning}& #2}
		\ifthenelse{\equal{#3}{}}{}{\\{\sf Skdespelare}& #3}
		\ifthenelse{\equal{#4}{}}{}{\\{\sf Rekvisita}& #4}
		\ifthenelse{\equal{#5}{}}{}{\\{\sf Regi}& #5}
		\ifthenelse{\equal{#6}{}}{}{\\{\sf Ljud och ljus}& #6}
		\\
	\end{tabular}%
	\end{center}\addvspace{8mm plus 8mm minus 4mm}}


\newlength\@omstartwidth
\setlength\@omstartwidth\textwidth
\addtolength\@omstartwidth{-62pt}

\newenvironment{omstart}{%
	\vspace{7pt plus 3pt minus 3pt}%
	\hspace{20pt}\textcolor{omstart}{\vrule width 1pt}\hspace{10pt}%
	\begin{minipage}{\@omstartwidth}%
}{\end{minipage}}

\newenvironment{ramanus}{%
	\begin{center}%
		{\bfseries Rmanus\par}%
		\vspace{5pt plus 3pt minus 3pt}%
		\begin{minipage}{10cm}%
			\setlength\parskip{7pt plus 3pt minus 3pt}%
			\small\tt
}{\end{minipage}\end{center}}

\newenvironment{replik}[1]{\begin{@replik}{\bfseries #1}}{\end{@replik}}
\newenvironment{minreplik}[1]{\begin{@replik}{#1}}{\end{@replik}}
\newenvironment{@replik}[1]{%
	\addvspace{2mm plus 3mm minus 1mm}
	\begin{flushleft}
		\setlength\leftskip{30pt}
		\setlength\parskip{7pt plus 3pt minus 3pt}
		{\hspace{-30pt}\sf #1\par}
		\vspace{-7pt plus 3pt}
		\newcommand\p{\vspace{7pt plus 3pt minus 3pt}}
}{\end{flushleft}\addvspace{2mm plus 3mm minus 1mm}}
\newcommand\rad[1]{\hspace{-10pt}#1\\}
\newcommand\anm[1]{{\small\it (#1)}}
\newcommand\fet[1]{{\bfseries #1}}


\newcommand\sang[7]{%
	\addvspace{8mm plus 8mm minus 4mm}
	\begin{center}
	\sangbeskrstorl
	\begin{tabular}{|lp{8cm}|}\hline
		\multicolumn{2}{|c|}{\large\bfseries\rule[-0.4\baselineskip]{0pt}{1.3\baselineskip}Sng}\\\hline
		\ifthenelse{\equal{#1}{}}{{\sf Namn}& Namn ej klart}{{\sf Namn}& #1}
		\ifthenelse{\equal{#2}{}}{}{\\{\sf Beskrivning}& #2}
		\ifthenelse{\equal{#3}{}}{}{\\{\sf Huvudsng}& #3}
		\ifthenelse{\equal{#4}{}}{}{\\{\sf Med p scen}& #4}
		\ifthenelse{\equal{#5}{}}{}{\\{\sf Musik}& #5}
		\ifthenelse{\equal{#6}{}}{}{\\{\sf Text}& #6}
		\ifthenelse{\equal{#7}{}}{}{\\{\sf Arrangemang}& #7}
		\\\hline
	\end{tabular}
	\end{center}\addvspace{8mm plus 8mm minus 4mm}}

\newcommand\kommentar[1]{\addvspace{5mm plus 2mm minus 2mm}%
	\begin{center}%
	\begin{minipage}{10cm}
		\centering\it\small #1%
	\end{minipage}
	\end{center}%
	\addvspace{5mm plus 2mm minus 2mm}}
\definecolor{omstart}{rgb}{1,0,1}
\definecolor{meta}{rgb}{1,0,0}
\newcommand\meta[2]{\addvspace{5mm plus 2mm minus 2mm}%
	\begin{center}%
		\textcolor{meta}{#2 [\emph{#1}]}%
	\end{center}%
	\addvspace{5mm plus 2mm minus 2mm}}
%
% New pagestyles.
%
\pagestyle{fancy}
\fancyhead[RO,LE]{\@title\\\leftmark}
\fancyhead[RE,LO]{\sl\lastrightmark}
\cfoot{Sida \thepage\ av \pageref{LastPage}}
\fancyfoot[RO,LE]{\@date}
\renewcommand\footrulewidth{0.1pt}
\setlength\headheight{2\baselineskip}
\let\scenbeskrstorl=\footnotesize
\let\sangbeskrstorl=\footnotesize
%
\setlength\parindent{0pt}
%
% Redefine standard section definitions
%
\renewcommand\section[2]{\markboth{#2}{}\@startsection{section}{1}{\z@}%
	{-3.5ex \@plus -1ex \@minus -.2ex}%
	{2.3ex \@plus.2ex}%
	{\normalfont\Huge\bfseries}#1{#2}}
\renewcommand\subsection[2]{\markright{#2}\@startsection{subsection}{2}{\z@}%
	{-3.25ex\@plus -1ex \@minus -.2ex}%
	{1.5ex \@plus .2ex}%
	{\normalfont\LARGE\sf\bfseries}#1{#2}}
%
\renewcommand\maketitle{%
	\begin{titlepage}%
	\let\footnotesize\small
	\let\footnoterule\relax
	\null\vfil
	\vskip 60\p@
	\begin{center}%
		{\Huge \@title \par}%
		{\LARGE \@subtitle \par}%
		\vskip 3em%
		{\Large \@date \par}%
	\end{center}\par
	\vfil\null
	\end{titlepage}%
}
\def\subtitle#1{\gdef\@subtitle{#1}}
\def\@subtitle{\@latex@warning@no@line{No \noexpand\subtitle given}}
%
% EOF
%
