<?xml version="1.0" encoding="iso-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="iso-8859-1" indent="yes" media-type="text/html" />

<!-- Dokumenttyp -->
<xsl:template match="spexml">
	<html>
	<xsl:comment> Automatgenererat HTML-dokument.        </xsl:comment>
	<xsl:comment> versatt frn SpeXML med hjlp av XSL. </xsl:comment>
	<xsl:comment> Editera inte detta dokument!           </xsl:comment>
	<xsl:comment> (c) 1999 Napoleon.                     </xsl:comment>
	<xsl:comment> (c) 2004 McCarthy.                     </xsl:comment>
	<head>
		<meta name="generator" content="Xalan-C with spexml2html.xsl" />
		<link rel="stylesheet" href="http://www.d.kth.se/namnder/dataspelet/spexml/spexml-html.css" type="text/css" />
		<title><xsl:value-of select="@titel" />, <xsl:value-of select="@undertitel" /></title>
	</head>
	<body>
		<xsl:apply-templates select="revision" />
		<xsl:apply-templates select="akt" />
	</body>
	</html>
</xsl:template>

<xsl:template name="rcstag">
	<xsl:param name="data"></xsl:param>
<xsl:value-of select="substring-before(substring-after($data, ':'), '$')" />
</xsl:template>

<xsl:template match="revision">
	<table class="revision">
	<tr>
		<td class="etikett">Revision</td>
		<td><xsl:call-template name="rcstag"><xsl:with-param name="data"><xsl:value-of select="@version" /></xsl:with-param></xsl:call-template></td>
	</tr>
	<tr>
		<td class="etikett">Senast ndrad</td>
		<td><xsl:call-template name="rcstag"><xsl:with-param name="data"><xsl:value-of select="@datum" /></xsl:with-param></xsl:call-template></td>
	</tr>
	<tr>
		<td class="etikett">ndrad av</td>
		<td><xsl:call-template name="rcstag"><xsl:with-param name="data"><xsl:value-of select="@ndradav" /></xsl:with-param></xsl:call-template></td>
	</tr>
	</table>
</xsl:template>

<!-- Akt -->

<xsl:template match="akt">
	<div class="akt">
		<h1><xsl:value-of select="@titel"/></h1>
		<div class="scen tos">
			<h2>Disposition</h2>
			<ul>
			<xsl:for-each select="scen">
				<li class="scen">
					Scen <xsl:value-of select="@nr" />, <a href="#scen{@nr}"><xsl:value-of select="scenhuvud/namn" /></a>
					<ol>
					<xsl:for-each select="sng">
						<li><xsl:value-of select="namn" /></li>
					</xsl:for-each>
					</ol>
				</li>
			</xsl:for-each>
			</ul>
		</div>
		<xsl:apply-templates/>
	</div>
</xsl:template>

<!-- Scen -->

<xsl:template match="scen">
	<div class="scen">
		<h2>Scen <xsl:value-of select="@nr"/></h2><a id="scen{@nr}" />
		<xsl:apply-templates/>
	</div>
</xsl:template>

<xsl:template match="scenhuvud">
	<table class="scenhuvud">
		<xsl:apply-templates/>
	</table>
</xsl:template>

<xsl:template match="sng">
	<table class="sng" cellpadding="0" cellspacing="0">
	<tr>
		<td align="center"><img alt="" height="32" width="32" src="http://www.d.kth.se/namnder/dataspelet/spexml/song.gif" /></td>
		<td>
		<table>
			<xsl:apply-templates/>
		</table>
		</td>
	</tr>
	</table>
</xsl:template>

<xsl:template match="replik">
	<h4 class="replik"><xsl:value-of select="@aktr"/></h4>
	<p class="replik"><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="kommentar">
	<p class="kommentar"><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="omstart">
	<h4 class="omstart">Omstart</h4>
	<div class="omstart"><xsl:apply-templates/></div>
</xsl:template>

<xsl:template match="rmanus">
	<h4 class="rmanus">Rmanus</h4>
	<div class="rmanus"><xsl:apply-templates/></div>
</xsl:template>

<xsl:template match="stycke">
	<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="lnk">
	<a href="{@url}"><xsl:apply-templates/></a>
</xsl:template>

<xsl:template match="meta">
	<p class="meta"><xsl:apply-templates /> [<i class="skribent"><xsl:value-of select="@skribent" /></i>]</p>
</xsl:template>


<!-- Scenhuvud -->

<xsl:template match="scenhuvud/namn">
	<tr>
		<td class="etikett">Namn</td>
		<td class="namn"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="scenhuvud/beskrivning">
	<tr>
		<td class="etikett">Beskrivning</td>
		<td class="beskrivning"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="skdisar">
	<tr>
		<td class="etikett">Skdespelare</td>
		<td class="skdespelare"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="rekvisita">
	<tr>
		<td class="etikett">Rekvisita</td>
		<td class="rekvisita"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="regi">
	<tr>
		<td class="etikett">Regi</td>
		<td class="regi"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="lol">
	<tr>
		<td class="etikett">Ljud &amp; ljus</td>
		<td class="lol"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<!-- Sng -->

<xsl:template match="sng/namn">
	<tr>
		<td class="etikett">Sng</td>
		<td class="namn"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="sng/beskrivning">
	<tr>
		<td class="etikett">Beskrivning</td>
		<td class="beskrivning"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="huvud">
	<tr>
		<td class="etikett">Huvudsng</td>
		<td class="huvud"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="med">
	<tr>
		<td class="etikett">Med p scen</td>
		<td class="med"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="musik">
	<tr>
		<td class="etikett">Musik</td>
		<td class="musik"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="text">
	<tr>
		<td class="etikett">Text</td>
		<td class="text"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<xsl:template match="arr">
	<tr>
		<td class="etikett">Arrangemang</td>
		<td class="arr"><xsl:apply-templates/></td>
	</tr>
</xsl:template>

<!-- Replik -->

<xsl:template match="rad">
	<xsl:apply-templates/><br />
</xsl:template>

<xsl:template match="anm">
	<i class="anm">(<xsl:apply-templates />)</i>
</xsl:template>

<xsl:template match="fet">
	<b class="fet"><xsl:apply-templates /></b>
</xsl:template>

<!-- Specialtecken  -->

<xsl:template match="citat">"</xsl:template>
<xsl:template match="apostrof">'</xsl:template>
<xsl:template match="och">&#38;</xsl:template>
<xsl:template match="streck">&#150;</xsl:template>
<xsl:template match="ellips">...</xsl:template>
<xsl:template match="nollan">&#216;</xsl:template>

<xsl:template match="eakut">&#233;</xsl:template>
<xsl:template match="egrav">&#232;</xsl:template>
<xsl:template match="aakut">&#225;</xsl:template>
<xsl:template match="agrav">&#224;</xsl:template>
<xsl:template match="tyskty">&#252;</xsl:template>

</xsl:stylesheet>
