<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/TR/REC-html40" version="1.0">
<xsl:output method="html" encoding="iso-8859-1" indent="yes" media-type="text/html"/>

<!-- Dokumenttyp -->

<xsl:template match = "spexml">
<xsl:comment> Automatgenererat HTML-dokument.        </xsl:comment>
<xsl:comment> versatt frn SpeXML med hjlp av XSL. </xsl:comment>
<xsl:comment> Editera inte detta dokument!           </xsl:comment>
<xsl:comment> (c) 1999 Napoleon.                     </xsl:comment>

<html>
<head>
<meta name="generator" content="spexml2html"/>
</head>
<body bgcolor="#ffffff">
<center>
<table width="550">
<tr><td>
<xsl:apply-templates/>
</td></tr>
</table>
</center>
</body>
</html>
</xsl:template>

<!-- Akt -->

<xsl:template match = "akt">
<h1><xsl:value-of select="@titel"/></h1>
<xsl:apply-templates/>
</xsl:template>

<!-- Scen -->

<xsl:template match = "scen">
<h3>Scen <xsl:value-of select="@nr"/></h3>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "scenhuvud">
<table border="1" cellspacing="0" width="500">
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match = "sng">
<p>
<table border="1" cellspacing="0" width="400">
<xsl:apply-templates/>
</table>
</p>
</xsl:template>

<xsl:template match = "replik">
<p>
<dt><xsl:value-of select="@aktr"/>:</dt>
<xsl:apply-templates/>
</p>
</xsl:template>

<xsl:template match = "kommentar">
<p>
<i><xsl:apply-templates/></i>
</p>
</xsl:template>

<xsl:template match = "omstart">
<p>
<center>
<table border="1" width="500">
<tr><td>
<xsl:apply-templates/>
</td></tr>
</table>
</center>
</p>
</xsl:template>

<xsl:template match = "stycke">
<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match = "lnk">
<a href="{@url}"><xsl:apply-templates/></a>
</xsl:template>

<xsl:template match = "meta">
<p>
<font face="Arial,Helvetica" color="#ff0000">
<xsl:apply-templates/> &#91;<xsl:value-of select="@skribent"/>&#93;
</font>
</p>
</xsl:template>


<!-- Scenhuvud -->

<xsl:template match = "scenhuvud/namn">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Namn</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "scenhuvud/beskrivning">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Beskrivning</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "skdisar">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Skdespelare</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "rekvisita">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Rekvisita</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "regi">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Regi</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "lol">
<tr>
<td width="100" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Ljud &amp; ljus</font></b>
</td>
<td width="400">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<!-- Sng -->

<xsl:template match = "sng/namn">
<tr>
<td align="center" valign="center" rowspan="7" width="80" bgcolor="#cccccc">
<center>
<img src="http://www.d.kth.se/namnder/dataspelet/spexml/song.gif" alt="Sng" border="0" height="32" width="32"/>
</center>
</td>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Sng</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "sng/beskrivning">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Beskrivning</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "huvud">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Huvudsng</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "med">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Med p scen</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "musik">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Musik</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "text">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Text</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<xsl:template match = "arr">
<tr>
<td width="80" bgcolor="#cccccc">
<b><font size="-1" face="Arial,Helvetica">Arrangemang</font></b>
</td>
<td width="240">
<font size="-1" face="Arial,Helvetica"><xsl:apply-templates/></font>
</td>
</tr>
</xsl:template>

<!-- Replik -->

<xsl:template match = "rad">
<dd><xsl:apply-templates/>&#160;</dd>
</xsl:template>

<xsl:template match = "anm">
<i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match = "fet">
<b><xsl:apply-templates/></b>
</xsl:template>

<!-- Specialtecken  -->

<xsl:template match = "citat">&#8221;</xsl:template>
<xsl:template match = "apostrof">&#8217;</xsl:template>
<xsl:template match = "och">&#38;</xsl:template>
<xsl:template match = "streck">&#8211;</xsl:template>
<xsl:template match = "ellips">&#8230;</xsl:template>
<xsl:template match = "nollan">&#216;</xsl:template>

<xsl:template match = "eakut">&#233;</xsl:template>
<xsl:template match = "egrav">&#232;</xsl:template>
<xsl:template match = "aakut">&#225;</xsl:template>
<xsl:template match = "agrav">&#224;</xsl:template>
<xsl:template match = "tyskty">&#252;</xsl:template>

</xsl:stylesheet>
