<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" encoding="iso-8859-1"/>

<!-- Normalisera all blanktecken (undvik styckebrytning i TeX) -->
<xsl:template match="text()">
<xsl:if test="substring(.,1,1)=' '
				or substring(.,1,1)='&#x9;'
				or substring(.,1,1)='&#xA;'
				or substring(.,1,1)='&#xD;'">
	<xsl:text> </xsl:text>
</xsl:if>
<xsl:value-of select="normalize-space(.)" />
<xsl:if test="substring(.,string-length(.),1)=' '
				or substring(.,string-length(.),1)='&#x9;'
				or substring(.,string-length(.),1)='&#xA;'
				or substring(.,string-length(.),1)='&#xD;'">
	<xsl:text> </xsl:text>
</xsl:if>
</xsl:template>

<!-- Dokumenttyp -->

<xsl:template match = "spexml">

%
%   foo.tex -- Manus i TeX-format.
%
%      Automatgenererat TeX-dokument. versatt frn
%      SpeXML med hjlp av XSL. Editera inte detta dokument!
%
%      (c) 1999 Napoleon.
%

\documentclass[a4paper]{article}

\usepackage[latin1]{inputenc}  % Svenska tecken i inmatningen
\usepackage[T1]{fontenc}       % Svensk avstavning fungerar
\usepackage[swedish]{babel}    % Allmn svenskifiering
\usepackage[final]{graphicx}   % EPS-bilder i dokumentet

\renewcommand{\labelenumi}{(\arabic{enumi})}

\newenvironment{kommentar}
   {\vspace{-1mm}\begin{em}\begin{footnotesize}
      \begin{list}{}{
         \setlength{\rightmargin}{60pt}
         \setlength{\leftmargin}{40pt}}
      \item[]}
   {\end{list}\end{footnotesize}\end{em}\vspace{1mm}}

\newenvironment{replik}[1]
   {\vspace{-1mm}
    \noindent\textsc{\lowercase{#1}}
    \nopagebreak[4]
    \vspace{-2mm}
    \nopagebreak[4]
    \begin{verse}
    \nopagebreak[4]}
   {\end{verse}}

\setlength{\textwidth}{320pt}
\setlength{\oddsidemargin}{80pt}

\begin{document}
<xsl:apply-templates/>
\end{document}

</xsl:template>

<!-- Akt -->

<xsl:template match = "akt">
	\section*{<xsl:value-of select="@titel"/>}
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "scen">
	\subsection*{Scen <xsl:value-of select="@nr"/>}
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "scenhuvud">
\begin{tabular}[!h]{p{45pt}p{200pt}}
<xsl:apply-templates/>
\end{tabular}
\vspace{4mm}
</xsl:template>

<xsl:template match = "sng">
\begin{center}
\begin{tabular}[!h]{|p{45pt}p{200pt}|}
\hline
<xsl:apply-templates/>
\hline
\end{tabular}
\vspace{4mm}
\end{center}
</xsl:template>

<xsl:template match = "replik">
	\begin{replik}{<xsl:value-of select="@aktr"/>}
<xsl:apply-templates/>
	\end{replik}
</xsl:template>

<xsl:template match = "kommentar">
\begin{kommentar}
<xsl:apply-templates/>
\end{kommentar}
</xsl:template>

<xsl:template match = "omstart">
\begin{tabular}[!h]{p{1pt}|p{280pt}}
\span
<xsl:apply-templates/>
\vspace{-6mm}
\end{tabular}
\vspace{2mm}
</xsl:template>

<xsl:template match = "stycke"><xsl:apply-templates/>\par</xsl:template>

<xsl:template match = "lnk"><xsl:apply-templates/></xsl:template>

<xsl:template match = "meta">
\noindent\textsf{<xsl:apply-templates/> [<xsl:value-of select="@skribent"/>]}
</xsl:template>

<!-- Scenhuvud -->

<xsl:template match = "scenhuvud/namn">\footnotesize\textsf{Namn} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "scenhuvud/beskrivning">\footnotesize\textsf{Beskrivning} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "skdisar">\footnotesize\textsf{Skdisar} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "rekvisita">\footnotesize\textsf{Rekvisita} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "regi">\footnotesize\textsf{Regi} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "lol">\footnotesize\textsf{Ljud och ljus} \footnotesize\span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<!-- Sng -->

<xsl:template match = "sng/namn">\footnotesize\textsf{Sng} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "sng/beskrivning">\footnotesize\textsf{Beskrivning} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "huvud">\footnotesize\textsf{Huvudsng} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "med">\footnotesize\textsf{Med p scen} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "musik">\footnotesize\textsf{Musik} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "text">\footnotesize\textsf{Text} \span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>

<xsl:template match = "arr">\footnotesize\textsf{Arrangemang} \footnotesize\span \footnotesize\textsf{\noindent <xsl:apply-templates/>}\\</xsl:template>


<!-- Replik -->

<xsl:template match = "rad"><xsl:apply-templates/>~\\</xsl:template>

<xsl:template match = "anm">{\em <xsl:apply-templates/>}</xsl:template>

<xsl:template match = "fet">{\bf <xsl:apply-templates/>}</xsl:template>

<!-- Specialtecken  -->

<xsl:template match = "citat">''</xsl:template>
<xsl:template match = "apostrof">'</xsl:template>
<xsl:template match = "och">och</xsl:template>
<xsl:template match = "streck">--</xsl:template>
<xsl:template match = "ellips">\ldots\ </xsl:template>
<xsl:template match = "nollan">\O </xsl:template>

<xsl:template match = "eakut">\'e</xsl:template>
<xsl:template match = "egrav">\`e</xsl:template>
<xsl:template match = "aakut">\'a</xsl:template>
<xsl:template match = "agrav">\`a</xsl:template>
<xsl:template match = "tyskty">\"u</xsl:template>

</xsl:stylesheet>
