<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" encoding="iso-8859-1"/>

<!-- Normalisera all blanktecken (undvik styckebrytning i TeX) -->
<xsl:template match="text()">
<xsl:if test="substring(.,1,1)=' '
				or substring(.,1,1)='&#x9;'
				or substring(.,1,1)='&#xA;'
				or substring(.,1,1)='&#xD;'">
<xsl:text> </xsl:text>
</xsl:if>
<xsl:value-of select="normalize-space(.)" />
<xsl:if test="substring(.,string-length(.),1)=' '
				or substring(.,string-length(.),1)='&#x9;'
				or substring(.,string-length(.),1)='&#xA;'
				or substring(.,string-length(.),1)='&#xD;'">
<xsl:text> </xsl:text>
</xsl:if>
</xsl:template>

<!-- Dokumenttyp -->
<xsl:template match="spexml">
	%
	% Automatgenererat TeX-dokument. versatt frn SpexML.
	% Editera inte detta dokument!
	%
	% (c) 2004 Konglig Datasektionen
	%
	
	\documentclass{spex}
	
	\title{<xsl:value-of select="@titel" />}
	\subtitle{<xsl:value-of select="@undertitel" />}
	\date{%
	<xsl:value-of select="normalize-space(substring-before(substring-after(revision/@datum, ':'), '$'))" />,
	<xsl:value-of select="normalize-space(substring-before(substring-after(revision/@version, ':'), '$'))" />}
	
	\begin{spex}\maketitle
	<xsl:apply-templates select="akt" />
	\end{spex}
</xsl:template>

<!-- Akt -->

<xsl:template match="akt">
	\akt{<xsl:value-of select="@titel"/>}
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="scen">
	\scen{<xsl:value-of select="@nr"/>}%
		{<xsl:value-of select="scenhuvud/namn"/>}%
		{<xsl:value-of select="scenhuvud/beskrivning"/>}%
		{<xsl:value-of select="scenhuvud/skdisar"/>}%
		{<xsl:value-of select="scenhuvud/rekvisita"/>}%
		{<xsl:value-of select="scenhuvud/regi"/>}%
		{<xsl:value-of select="scenhuvud/lol"/>}
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="scenhuvud">
</xsl:template>

<xsl:template match="sng">
	\sang{<xsl:value-of select="namn"/>}%
		{<xsl:value-of select="beskrivning"/>}%
		{<xsl:value-of select="huvud"/>}%
		{<xsl:value-of select="med"/>}%
		{<xsl:value-of select="musik"/>}%
		{<xsl:value-of select="text"/>}%
		{<xsl:value-of select="arr"/>}
</xsl:template>

<xsl:template match="replik">
	\begin{replik}{<xsl:value-of select="@aktr"/>}
	<xsl:apply-templates/>
	\end{replik}
</xsl:template>

<xsl:template match="kommentar">
	\kommentar{<xsl:apply-templates/>}
</xsl:template>

<xsl:template match="omstart">
	\begin{omstart}
	<xsl:apply-templates/>
	\end{omstart}
</xsl:template>

<xsl:template match="rmanus">
	\begin{ramanus}
	<xsl:apply-templates/>
	\end{ramanus}
</xsl:template>

<xsl:template match="stycke"><xsl:apply-templates/>\p</xsl:template>

<xsl:template match="lnk"><xsl:apply-templates/></xsl:template>

<xsl:template match = "meta">
	\meta{<xsl:value-of select="@skribent"/>}{<xsl:apply-templates/>}
</xsl:template>

<!-- Replik -->

<xsl:template match="rad">\rad{<xsl:apply-templates/>}</xsl:template>

<xsl:template match="anm">\anm{<xsl:apply-templates/>}</xsl:template>

<xsl:template match="fet">\fet{<xsl:apply-templates/>}</xsl:template>

<!-- Specialtecken  -->

<xsl:template match="citat">''</xsl:template>
<xsl:template match="apostrof">'</xsl:template>
<xsl:template match="och">\&amp;{}</xsl:template>
<xsl:template match="streck">--</xsl:template>
<xsl:template match="ellips">\ldots{}</xsl:template>
<xsl:template match="nollan">\O </xsl:template>

<xsl:template match="eakut">\'e</xsl:template>
<xsl:template match="egrav">\`e</xsl:template>
<xsl:template match="aakut">\'a</xsl:template>
<xsl:template match="agrav">\`a</xsl:template>
<xsl:template match="tyskty">\"u</xsl:template>
</xsl:stylesheet>
