;This is how a list of segments should look like 
;Each pair describes a segment between two nodes.
;A segment is a part in a net.
(define seg-list '((a . b)
		   (a . c)
		   (a . g)
		   (a . f)
		   (f . d)
		   (f . e)
		   (e . d)
		   (e . g)
		   (h . i)
		   (j . l)
		   (l . m)
		   (j . m)
		   (j . k)))

;Insert a segment pair in an adjacent list.
;Returns the new adjacent list
(define (insert-seg seg adjlist)
  (cond ((null? adjlist) ; Hasn't found a matching head
	 (list (cons (car seg) (list (cdr seg)))))
	((equal? (car seg) (caar adjlist)) ;Head matching!
	 (cons (cons (car seg) ;Head
		     (cons (cdr seg) ;List
			   (cdar adjlist)))
	       ; Rest of (head . list)'s
	       (cdr adjlist)))
	(else ; Continue the quest for matching head
	 (cons (car adjlist)
	       (insert-seg seg (cdr adjlist))))))

;;Insert a list of segment pairs and return an adjacent list
;It insert both the pair and the reversed pair as needed by the adjacent list
;algorithm desribed in Sedgewick's book
(define (insert-seg-list seg-list)
  (if (null? seg-list)
      '()
      (insert-seg (car seg-list)
		  (insert-seg (cons (cdar seg-list) (caar seg-list)) ;Reversed pair
			      (insert-seg-list (cdr seg-list))))))


;; Adjacent list according to "Algorithms, Second Edition",
;;  Sedgewick pp.420-423


; This is how a adjlist should look like
; From "The Book". Note this is generally the same list
; returned from (insert-seg-list seg-list) described above.
(define my-adjlist
  '((a . (f c b g)) ;A branch is '(head . list)
    (b . (a))       ;in the adjlist
    (c . (a))
    (d . (f e))
    (e . (g f d))
    (f . (a e d))
    (g . (e a))
    (h . (i))
    (i . (h))
    (j . (k l m))
    (k . (j))
    (l . (j m))
    (m . (j l))
    ))


(define (traverse-adjlist adjlist)
  

  (define visited '())
  
  (define (visited? node)
    (if (memq node visited)
	#t
	#f))
  
  
  (define (traverse-branch head)
    (let ((current-branch (assoc head adjlist))) ; current-branch is a simple list
      (and current-branch
	   (not (visited? head))
	   (begin
	     (set! visited (append visited (list head)))
	     (cons head
		   (traverse-list (cdr current-branch)))))))
  
  
  (define (traverse-list blist)
    (cond ((null? blist) 
	   '()) 
	  ((visited? (car blist)) 
	   (traverse-list (cdr blist)))
	  (else 
	   (append
	    (traverse-branch (car blist))
	    (traverse-list (cdr blist))))))

  
  (define (extract-head adjlist)
    (if (null? (cdr adjlist))
	(list (caar adjlist))
	(cons (caar adjlist)
	      (extract-head (cdr adjlist)))))
  
 
  (define (loop-through-list blist)
    (cond ((null? blist)
	   '())
	  ((visited? (car blist))
	   (loop-through-list (cdr blist)))
	  (else
	   (cons (traverse-branch (car blist))
		 (loop-through-list (cdr blist))))))

  (loop-through-list (extract-head adjlist)))
