#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "mpt1327.h"

#define MPT1327_POLYNOM 0x6815

static int
getbit(int n, u_int16_t *codewords)
{
    u_int16_t mask;
    u_int16_t codeword;

    codeword = codewords[n/16];
    mask = 1<<(15-(n%16));

    return (codeword & mask)?1:0;
}


static u_int16_t
mpt1327_fcs(mpt1327_t *m)
{
    int n, bit;
    u_int16_t syndrome = 0, parity = 0;

    for (n = 0; n < 64; n++) {
	bit = getbit(n, m->codeword);
	parity ^= bit;
	if (n == 62) bit ^= 1;
	if (n < 63) {
	    syndrome <<= 1;
	    if (bit ^ ((syndrome & 0x8000)?1:0))
		syndrome ^= 0x6815;
	}
    }

    syndrome &= 0x7fff;
    if (parity)
	syndrome |= 0x8000;
    
    return syndrome;
}


void
mpt1327(unsigned char bit, mpt1327_t *m)
{
    u_int16_t para;

    /*
     * Shift in the least significant bit into the 64 bit frame.
     */
    m->codeword[0] <<= 1;
    m->codeword[0] += (m->codeword[1] & 0x8000)?1:0;
    m->codeword[1] <<= 1;
    m->codeword[1] += (m->codeword[2] & 0x8000)?1:0;
    m->codeword[2] <<= 1;
    m->codeword[2] += (m->codeword[3] & 0x8000)?1:0;
    m->codeword[3] <<= 1;
    if (bit) m->codeword[3] += 1;
    m->cnt++;

    switch (m->state) {
    case 0:
	if (((m->codeword[3] & 0xffff) == MPT1327_SYNC) ||
	    ((m->codeword[3] & 0xffff) == MPT1327_SYNT)) {
	    if (mpt1327_fcs(m) == 0) {
#if 1
		switch (m->codeword[0] & 0x7fff) { /* SYS */
		case 0x0509:
		    printf("BUDBIL ");
		    break;
		case 0x0781:
		    printf("SKANSKA ");
		    break;
		case 0x2491:
		    printf("MPT Comm ");
		    break;
		default:
		    printf("SYS 0x%4.4x ", m->codeword[0] & 0x7fff);
		}
		printf("\n");
		fflush(stdout);
#endif
	    }
	    m->state = 1;
	    m->cnt = 0;
	}
	break;
    case 1:
	if (m->cnt == 64) {
	    if (mpt1327_fcs(m) == 0) {
#if 0
		if (m->codeword[0] & 0x8000) {
		    printf("A ");
		} else {
		    printf("D ");
		}
#endif
		if (m->codeword[1] & (1<<10)) {
#if 1
		    para = m->codeword[2];
		    para += (m->codeword[1] & 0x03) << 16;

		    /* Endast nedkopplingen */
		    if ((para & 0xaaa) == 0xaaa) {
			time_t t = time(NULL);
			printf("GAC CHAN: 0x%x %s", 
			       m->codeword[0]>>5 & 0x2ff, ctime(&t));
#if 0
			printf("CAT: 0x%1.1x ", (m->codeword[1]>>7) & 0x7);
			printf("TYPE: 0x%1.1x ", (m->codeword[1]>>5) & 0x3);
			printf("FUNC: 0x%1.1x ", (m->codeword[1]>>2) & 0x7);
			printf("PARA: 0x%5.5x ", para);
			printf("CHAN: 0x%x", m->codeword[0]>>5 & 0x2ff);
			printf("\n");
#endif
		    }
#endif
		} else {
		    printf("GTC ");
		    printf("Channel 0x%x ", (m->codeword[1] << 1 | m->codeword[2] >> 15) & 0x3ff);
		    printf("0x%4.4x ", m->codeword[0]);
		    printf("%4.4x ", m->codeword[1]);
		    printf("%4.4x ", m->codeword[2]);
		    printf("[%4.4x]", m->codeword[3]);
		    printf("\n");
		}

	    }
	    m->state = 0;
	    m->cnt = 0;
	}
	break;
    default:
	m->state = 0;
    }
}
