/* Program to generate a binary matrix in 
 * textformat for simple inclusion
 * in Matlab.N cols and 2^N rows.
 *
 * Stefan Petersen, Royal Institute of Technology, 1997
 */

#include <stdlib.h>
#include <stdio.h>


void usage()
{
  printf("(C) Stefan Petersen, ");
  printf("Royal Institute of Technology, 1997\n");
  printf("\nUsage:\n");
  printf("binmat <N> <filename>\n");
  printf("where N is number of zeroes off the circle and \n");
  printf("filename is the name of file to ");
  printf("save the matrix in.\n");


  return;
}

void main(int argc, char *argv[])
{
  FILE *fs;
  char *filename;
  char matrixname[] = "binmat";
  int n,N;
  long temp,m,M;



  if (argc != 3) {
    printf("Wrong number of arguments!\n");
    usage();
    exit(1);
  }

  if ((N = atoi(argv[1])) == 0){
    printf("Illegal form of N given\n");
    usage();
    exit(1);
  }
  M = (1<<N);

  filename = argv[2];

  if((fs = fopen(filename, "w+")) == NULL){
     fprintf(stderr, "Couldn't create %s\n", filename);
     exit(1);
  }

  fprintf(fs, "%s=[", matrixname);

  for(m = 0; m < M; m++){
    temp = m;
    for(n = 0; n < N; n++){
      fprintf(fs, "%d ", (temp & 0x01L)?1:-1);
      temp>>=1;
    }
    fprintf(fs, ";\n");
  }
  
  fprintf(fs, "];\n");
  fclose(fs);
  return;
}
